define([
    'jquery',
    'Magento_Checkout/js/view/payment/default',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/model/resource-url-manager',
    'mage/storage',
    'Magento_Checkout/js/model/payment/additional-validators',
    'Afterpay_Afterpay/js/action/create-afterpay-checkout',
    'Magento_Checkout/js/action/set-payment-information',
    'Magento_Checkout/js/model/error-processor',
    'Magento_Customer/js/customer-data',
    'Magento_Customer/js/section-config'
], function (
    $,
    Component,
    quote,
    resourceUrlManager,
    storage,
    additionalValidators,
    createAfterpayCheckoutAction,
    setPaymentInformationAction,
    errorProcessor,
    customerData,
    sectionConfig
) {
    'use strict';
    return function (Component) {
        return Component.extend({
            
            continueToAfterpay: function (data, event) {
                const self = this;
    
                if (event) {
                    event.preventDefault();
                }
    
                if (additionalValidators.validate() && this.isPlaceOrderActionAllowed() === true) {
                    this.isPlaceOrderActionAllowed(false);
    
                    setPaymentInformationAction(
                        self.messageContainer,
                        self.getData()
                    ).done(function () {
                        /* Start - Fix wrong address during restoration */
                        let dataBeforeClear = customerData.get('checkout-data')();
                        /* End */
                        const captureUrlPath = 'afterpay/payment/capture';
                        createAfterpayCheckoutAction(self.messageContainer, {
                            confirmPath: captureUrlPath,
                            cancelPath: captureUrlPath
                        }).done(function (response) {
                            const sections = sectionConfig.getAffectedSections(captureUrlPath);
                            customerData.invalidate(sections);
                            /* Start - Fix wrong address during restoration */
                            if (dataBeforeClear) {
                                customerData.set('checkout-data', dataBeforeClear);
                            }
                            /* End */
                            $.mage.redirect(response.afterpay_redirect_checkout_url);
                        }).always(function () {
                            self.isPlaceOrderActionAllowed(true);
                        });
    
                    }).fail(function (response) {
                        errorProcessor.process(response, self.messageContainer);
                    }).always(function () {
                        self.isPlaceOrderActionAllowed(true);
                    });
                }
            },
            
            getAfterPayLabel: function () {
                var format = window.checkoutConfig.priceFormat.pattern;

                storage.get(resourceUrlManager.getUrlForCartTotals(quote), false)
                    .done(
                        function (response) {
                            var installmentFee = response.base_grand_total / 4;
                            var formatInstallmentFee = format.replace(/%s/g, installmentFee.toFixed(window.checkoutConfig.priceFormat.precision));

                            $('.label.afterpay-label').append(`<span>Afterpay <span class="payment-method__afterpay-amount"> - ${formatInstallmentFee} x 4 Payments</span></span>`);
                        }
                    )
                    .fail(
                        function (response) {
                            return 'Error';
                        }
                    );
            }
        });
    }
});
