define([
    'jquery',
    'fancybox',
    'mage/translate',
    'slick',
    'jquery-ui-modules/widget',
], function ($, fancybox, $t) {
    'use strict';

    $.widget('od.mosaicGallery', {
        selectors: {
            galleryList: '.js-mosaic-gallery-list',
        },

        _create() {
            this.initFancybox();
            this.handleSlick();
            this.initViewMoreLess();

            $(window).on('resize', this.handleSlick.bind(this));
        },

        initFancybox() {
            fancybox.Fancybox.bind('[data-fancybox="product-gallery"]', {
                loop: true,
                buttons: [
                    'zoom',
                    'close'
                ],
                Hash: false,
                backdropClick: false,
                idle: false,
                Thumbs: {
                    type: "classic",
                },
                Toolbar: {
                    items: {
                        closeBtn: {
                            tpl:
                                `<button class="f-button custom-close-btn" title="Close" data-fancybox-close>
                                     <svg width="51" height="52" viewBox="0 0 51 52" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M12.8196 39.0208L38.2754 13.5649" stroke="#001E62" stroke-width="3" stroke-linecap="round"/>
                                        <path d="M12.8196 13.5649L38.2754 39.0208" stroke="#001E62" stroke-width="3" stroke-linecap="round"/>
                                     </svg>
                                 </button>`
                        },
                        plusBtn: {
                            tpl: `
                                <button class="f-button custom-zoom-btn" title="Zoom In" aria-label="Zoom In" data-panzoom-action="zoomIn">
                                    <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M20 38L20 2" stroke="#001E62" stroke-width="3" stroke-linecap="round"/>
                                        <path d="M2 20L38 20" stroke="#001E62" stroke-width="3" stroke-linecap="round"/>
                                    </svg>
                                </button>
                          `,
                        },
                        minusBtn: {
                            tpl: `
                                <button class="f-button custom-zoom-btn" title="Zoom Out" aria-label="Zoom Out"  data-panzoom-action="zoomOut">
                                    <svg width="44" height="4" viewBox="0 0 44 4" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <path d="M2 2H42" stroke="#001E62" stroke-width="3" stroke-linecap="round"/>
                                    </svg>
                                </button>
                            `,
                        },
                    },
                    display: {
                        left: [],
                        middle: [
                            'minusBtn',
                            'plusBtn',
                        ],
                        right: ["closeBtn"],
                    },
                },
            });
        },

        initSlick() {
            $(this.selectors.galleryList).not('.slick-initialized').slick({
                dots: true,
                arrows: false,
                infinite: false
            });
        },

        destroySlick() {
            if ($(this.selectors.galleryList).hasClass('slick-initialized')) {
                $(this.selectors.galleryList).slick('unslick');
            }
        },

        handleSlick() {
            const isMobile = window.innerWidth <= 1024;
            if (isMobile) {
                this.initSlick();
            } else {
                this.destroySlick();
            }
        },

        initViewMoreLess() {
            const $viewMoreBtn = $('#view-more-btn');
            const $items = $('.mosaic-gallery__item.is-hidden');
            let isHidden = true;

            $viewMoreBtn.text($t('View More'));

            $viewMoreBtn.on('click', () => {
                $items.toggleClass('is-active');
                $viewMoreBtn.toggleClass('is-active');
                isHidden = !isHidden;

                if (isHidden) {
                    $viewMoreBtn.text($t('View More'));

                    $('html, body').animate({
                        scrollTop: $(this.selectors.galleryList).offset().top
                    }, 600);
                } else {
                    $viewMoreBtn.text($t('View Less'));
                }
            });
        }

    });

    return $.od.mosaicGallery;
});
