define([
    'jquery',
    'Magento_Checkout/js/action/get-totals',
    'Magento_Customer/js/customer-data'
  ], function($, getTotalsAction, customerData){

    return function (config, element) {

        function updateShoppingCart(qty){
            var inputId = element.getAttribute('data-input-id');
            var hiddenShoppingCartProductQtyInput = document.getElementById(inputId);

            if (hiddenShoppingCartProductQtyInput) {
                hiddenShoppingCartProductQtyInput.value = qty;
            }

            var form = $('form#form-validate.form-cart');
            $.ajax({
                url: form.attr('action'),
                data: form.serialize(),
                showLoader: true,
                success: function (res) {
                    if (res.odMaxQtyError) {
                        location.reload();
                    }
                    let errorMessage
                        = "The requested quantity exceeds the maximum quantity allowed in shopping bag";
                    $('.message-error:contains("' + errorMessage + '")').hide();
                    var parsedResponse = $.parseHTML(res);
                    var result = $(parsedResponse).find("#form-validate");
                    var sections = ['cart'];

                    $("#form-validate").replaceWith(result);

                    /* Minicart reloading */
                    customerData.reload(sections, true);

                    /* Totals summary reloading */
                    var deferred = $.Deferred();
                    getTotalsAction([], deferred);
                },
                error: function (xhr, status, error) {
                    var err = eval("(" + xhr.responseText + ")");
                }
            });
        }

        element.addEventListener('change', function(e){
            var qtyOptionsEl = element.children;
            var selectedIndex = e.currentTarget.selectedIndex;
            var qty = qtyOptionsEl[selectedIndex].textContent;

            updateShoppingCart(qty);
        });
    }
});
