define([
    'underscore',
    'jquery',
    'uiRegistry',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/checkout-data',
    'Magento_Checkout/js/model/step-navigator',
    'Magento_InventoryInStorePickupFrontend/js/model/pickup-locations-service',
    'Magento_Checkout/js/model/checkout-data-resolver',
    'Magento_Checkout/js/action/select-shipping-address',    
    'Magento_Checkout/js/model/shipping-rates-validator',
    'Magento_Checkout/js/model/address-converter'
], function (
    _,
    $,
    registry,
    quote,
    checkoutData,
    stepNavigator,
    pickupLocationsService,
    checkoutDataResolver,
    selectShippingAddress,
    shippingRatesValidator,
    addressConverter
) {
    'use strict';

    var mixin = {


        /**
         * Override parent syncWithShipping method 
         *
         * @returns void
         */
         syncWithShipping: function () {
            var shippingStep = _.findWhere(stepNavigator.steps(), {
                code: 'shipping'
            });

            // <custom>
            if (shippingStep == undefined) {
                this.isVisible(false);
                return;
            }
            // </custom>

            shippingStep.isVisible.subscribe(function (isShippingVisible) {
                this.isVisible(this.isAvailable && isShippingVisible);
            }, this);
            this.isVisible(this.isAvailable && shippingStep.isVisible());
        },

        /**
         * Button text for the Click & Collect button
         * Will be different depending on if the method is available or not
         * @returns {string}
         */
        buttonText: function () {
            if (window.checkoutConfig.overdoseInStorePickup && window.checkoutConfig.overdoseInStorePickup.is_available_method) {
                return 'Click & Collect';
            } else {
                return 'Click & Collect (Unavailable)';
            }
        },

        /**
         * Disable the Click & Collect button if the method is not available
         * and switch to shipping if Click & Collect is currently selected but no inventory available
         * @returns {void}
         */
        isDisableCC: function ()  {

            var isMethodAvailable = window.checkoutConfig.overdoseInStorePickup && 
                                   window.checkoutConfig.overdoseInStorePickup.is_available_method;
            
            if (isMethodAvailable) {
                $('.action-select-store-pickup').removeAttr('disabled');
            } else {
                $('.action-select-store-pickup').attr('disabled', true);
                
                // Auto-switch to shipping if Click & Collect is currently selected but no inventory available
                var currentShippingMethod = quote.shippingMethod();
                var isClickAndCollectSelected = currentShippingMethod && 
                                              currentShippingMethod['carrier_code'] === 'instore';
                
                if (isClickAndCollectSelected) {
                    
                    // Clear any selected store location
                    // pickupLocationsService.selectForShipping(null);
                    checkoutData.setSelectedShippingAddress(null);
                    checkoutData.setSelectedPickupAddress(null);
                    // Switch to shipping delivery method
                    this.selectShipping();
                    
                }
            }
        },
        // override the preselectLocation method to use existing store-selector-mixin logic
        preselectLocation: function() {
            var selectedLocation

            if (!this.isStorePickupSelected()) {
                return;
            }

            selectedLocation = pickupLocationsService.selectedLocation();

            if (selectedLocation) {
                // If a location is already selected, ensure it goes through selectStoreOption
                // to maintain consistency with user selections
                this.callStoreSelectorMethod('selectStoreOption', selectedLocation);
                return;
            }
        },

        /**
         * Helper method to call store-selector-mixin methods with fallback
         */
        callStoreSelectorMethod: function(methodName, location) {
            var storeSelectorMixin = registry.get('store-selector-mixin');
            if (storeSelectorMixin && typeof storeSelectorMixin[methodName] === 'function') {
                storeSelectorMixin[methodName](location);
            } else {
                // Fallback to original behavior if mixin not available
                pickupLocationsService.selectForShipping(location);
            }
        },
    };

    return function (target) {
        return target.extend(mixin);
    };
});
