define([
    'jquery',
    'sha256'
], function ($, sha) {
    return function (config, element) {
        function openSubscribeModal() {
            subscribeModal.classList.add('active');
            pageWrapper.classList.add('enable-modal');
        }

        function closeSubscribeModal() {
            subscribeModal.classList.remove('active');
            pageWrapper.classList.remove('enable-modal');
        }

        var subscribeModal = element;
        var pageWrapper = document.querySelector('.page-wrapper');
        var openNewsletterButton = document.querySelector('a[href="#open-newsletter"]');

        var subscribeModalOverlay = document.querySelector('#subscribeModalOverlay');
        var subscribeModalCloseIcon = document.querySelector('#subscribeModalCloseIcon');
        var subscribeModalContentClose = document.querySelector('#subscribeModalContentClose');
        var subscribeSubmit = document.querySelector('.subscribe-modal__content__form button');


        if (subscribeSubmit) {
            subscribeSubmit.addEventListener('click', function () {
                let email = $('.subscribe-modal__content__form input[name="email"]').val();
                var hash = sha.create();
                hash.update(email);
                // data layer
                window.dataLayer = window.dataLayer || [];
                window.dataLayer.push({
                    'event': 'userIdentify',
                    'em': hash.hex(), // SHA256 hash of email addressaddress
                    'email' : email // Users actual email address.
                });
            });
        }

        if (openNewsletterButton) {
            openNewsletterButton.addEventListener('click', function () {
                openSubscribeModal();
            });
        }

        if (subscribeModalOverlay) {
            subscribeModalOverlay.addEventListener('click', function () {
                closeSubscribeModal();
            });
        }

        if (subscribeModalCloseIcon) {
            subscribeModalCloseIcon.addEventListener('click', function () {
                closeSubscribeModal();
            });
        }

        if (subscribeModalContentClose) {
            subscribeModalContentClose.addEventListener('click', function () {
                closeSubscribeModal();
            });
        }
    }
});
