define([
    "jquery",
],
    function ($) {
        "use strict";
        return function (config, element) {
            var bodyWrapper,pageWrapper,sideMenuContainer,sideMenuOverlay,menuTrigger,subMenuTrigger,subMenuWrapperTrigger,subMenuCloseTrigger,subMenuAccordianTrigger,mobileMenuHeaderLinkSearch;
            $.ajax({
                url: config.ajaxUrl,
                method: 'GET',
                success: function (data) {
                    element.querySelector('.ajax-mobile-menu').innerHTML = data;
                    bodyWrapper = document.querySelector('.body-wrapper');
                    pageWrapper = document.querySelector('.page-wrapper');
                    sideMenuContainer = document.querySelector('.header__side-menu');
                    sideMenuOverlay = sideMenuContainer.querySelector('.side-menu__overlay');
                    menuTrigger = sideMenuContainer.querySelectorAll('.side-menu__trigger, .mobile-menu__close-btn');
                    subMenuTrigger = sideMenuContainer.querySelectorAll('.mobile-menu__parent > .mobile-menu__label');
                    subMenuWrapperTrigger = sideMenuContainer.querySelectorAll('.mobile-menu__parent > .mobile-menu__link');
                    subMenuCloseTrigger = sideMenuContainer.querySelectorAll('.js-mobile-menu__back-nav');
                    subMenuAccordianTrigger = sideMenuContainer.querySelectorAll('.mobile-menu__subcontainer > .mobile-menu__inner-item');
                    mobileMenuHeaderLinkSearch = sideMenuContainer.querySelector('#mobileMenuHeaderLinkSearch');
                    init();
                }
            });
            function toggleSideMenu() {
                bodyWrapper.classList.toggle('side-menu--is-open');
                $('body').toggleClass('side-menu--is-open');

                if (bodyWrapper.classList.contains('side-menu--is-open')) {
                }
                else {
                    //close all submenu
                    if (document.querySelector('.mobile-menu__parent-inner.open')) {
                        document.querySelector('.mobile-menu__parent-inner.open').classList.remove('open');
                    }

                    if (document.querySelector('.mobile-menu__subcontainer.open')) {
                        document.querySelector('.mobile-menu__subcontainer.open').classList.remove('open');
                    }
                }
            }

            function openSubMenu(e) {
                e.preventDefault();

                var clickedElement = e.target;
                if (clickedElement.tagName.toLowerCase() == 'span') {
                    var parentATagEl = clickedElement.parentElement;
                    var aTagLinkExist = parentATagEl.href.indexOf('#') < 0 && parentATagEl.href !== ''; //if parentElement has link

                    if (aTagLinkExist) { window.location.href = parentATagEl.href; }
                    else {
                        var submenu = parentATagEl.nextElementSibling;
                        $('.mobile-menu').scrollTop(0);
                        submenu.classList.toggle('open');
                        bodyWrapper.classList.add('submenu-is-open');

                    }
                }
                else {
                    var parentInner = e.target.nextElementSibling;
                    $('.mobile-menu').scrollTop(0);
                    parentInner.classList.toggle('open');
                    bodyWrapper.classList.add('submenu-is-open');
                }
            }

            function closeSubMenu(e) {
                e.preventDefault();
                var $target = $(e.target);
                var $parentInner = $target.closest('.open');
                $parentInner.toggleClass('open');
                bodyWrapper.classList.remove('submenu-is-open');
            }

            function toggleSubMenuAccordian(e) {
                var targetElement = e.target;
                var isHrefALink = targetElement.attributes.href && targetElement.attributes.href.value !== '#';
                if (isHrefALink) { return; } //skip opening or closing of menu and go straight to link

                e.preventDefault();
                var $target = $(e.target);
                var $parentInner = $target.closest('.mobile-menu__subcontainer:not(.open)');
                $parentInner.toggleClass('open');
            }

            function init() {
                for (var i = 0; i < menuTrigger.length; i++) {
                    var el = menuTrigger[i];
                    el.addEventListener('click', function () {
                        toggleSideMenu();
                    });
                }

                if (sideMenuOverlay) {
                    sideMenuOverlay.addEventListener('click', function () {
                        toggleSideMenu();
                    });
                };

                for (var i = 0; i < subMenuTrigger.length; i++) {
                    var el = subMenuTrigger[i];
                    el.addEventListener('click', function (e) {
                        openSubMenu(e);
                    });
                }

                for (var i = 0; i < subMenuWrapperTrigger .length; i++) {
                    var el = subMenuWrapperTrigger [i];
                    el.addEventListener('click', function (e) {
                        openSubMenu(e);
                    });
                }



                for (var i = 0; i < subMenuAccordianTrigger.length; i++) {
                    var el = subMenuAccordianTrigger[i];
                    el.addEventListener('click', function (e) {
                        toggleSubMenuAccordian(e);
                    });
                }

                for (var i = 0; i < subMenuCloseTrigger.length; i++) {
                    var el = subMenuCloseTrigger[i];
                    el.addEventListener('click', function (e) {
                        closeSubMenu(e);
                    });
                }
            }
        }
    });


