<?php

declare(strict_types=1);

namespace Asics\Verifone\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Model\Order;
use Verifone\Hosted\Model\Verifone;

/**
 * Prevent email being sent for pending payment orders
 *
 * @see \Asics\Verifone\Plugin\SetSendEmailFlag
 */
class PreventPendingPaymentSalesEmail implements ObserverInterface
{

    /**
     * @inheritDoc
     */
    public function execute(Observer $observer): void
    {
        /** @var Order $order */
        $order = $observer->getData('order');

        if ($this->shouldPreventEmail($order)) {
            $order->setCanSendNewEmailFlag(false);
        }
    }

    /**
     * Check if pending payment Verifone order
     *
     * @param Order $order
     * @return bool
     */
    private function shouldPreventEmail(Order $order): bool
    {
        return $order->getPayment()->getMethod() === Verifone::CODE
            && $order->getStatus() === 'pending';
    }
}
