<?php

namespace Asics\Verifone\Plugin\Model\ResourceModel\Order\Handler;

use Magento\Sales\Model\Order;

class State
{
    /**
     * @param $subject
     * @param Order $order
     * @return Order[]
     */
    public function beforeCheck($subject, Order $order)
    {
        if ($order->getPayment()
            && $order->getPayment()->getMethod() == 'verifone_hosted'
            && $order->getState() == Order::STATE_PROCESSING
            && $order->getTotalPaid() == 0) {
            $order->setTotalPaid((float)$order->getGrandTotal());
            $order->setBaseTotalPaid((float)$order->getBaseGrandTotal());
        }
        return [$order];
    }
}
