define([
    'jquery',
    'underscore',
    'knockout',
    'mage/translate',
    'Magento_PageBuilder/js/events',
    'Magento_PageBuilder/js/content-type/preview-collection',
    'Magento_PageBuilder/js/uploader',
    'Magento_PageBuilder/js/config',

    'Magento_PageBuilder/js/content-type-factory', 'Magento_PageBuilder/js/content-type-menu/option'
], function (
    $,
    _,
    ko,
    $t,
    events,
    PreviewBase,
    uploader,
    config,

    createContentType, option) {
    'use strict';

    /**
     * @param parent
     * @param config
     * @param stageId
     * @constructor
     */
    function Preview(parent, config, stageId) {
        PreviewBase.call(this, parent, config, stageId);
    }

    Preview.prototype = Object.create(PreviewBase.prototype);

    Preview.prototype.uploader = null;


    Preview.prototype.bindEvents = function bindEvents() {
        var self = this;

        PreviewBase.prototype.bindEvents.call(this);

        events.on("asicspagebuilder_largecategorytile:dropAfter", function (args) {
            if (args.id === self.contentType.id && self.contentType.children().length === 0) {
                self.addLargeCategoryTilesButtons();
            }
        });

        /**
         * Bind events for image uploading API
         */

        events.on(this.config.name + ":" + this.contentType.id + ":updateAfter", function () {
            var dataStore = self.contentType.dataStore.getState();

            var files = dataStore[self.config.additional_data.uploaderConfig.dataScope];
            var imageObject = files ? files[0] : {};

            events.trigger("image:" + self.contentType.id + ":assignAfter", imageObject);
        });

        events.on(this.config.name + ":mountAfter", function () {
            var dataStore = self.contentType.dataStore.getState();

            var initialImageValue = dataStore[self.config.additional_data.uploaderConfig.dataScope] || "";

            self.uploader = new uploader(
                "imageuploader_" + self.contentType.id,
                self.config.additional_data.uploaderConfig,
                self.contentType.id,
                self.contentType.dataStore,
                initialImageValue
            );
        });

    };


    /** Return a new instance of the uploader to allow for inline image uploading capabilities
    *
    * @returns {*}
    */
    Preview.prototype.getUploader = function () {
        var initialImageValue = this.contentType.dataStore
            .get(this.config.additional_data.uploaderConfig.dataScope, "");

        return new uploader(
            "imageuploader_" + this.contentType.id,
            this.config.additional_data.uploaderConfig,
            this.contentType.id,
            this.contentType.dataStore,
            initialImageValue,
        );
    };




    /**
* Add buttons
*/
    Preview.prototype.addLargeCategoryTilesButtons = function () {
        var self = this;

        createContentType(
            config.getContentTypeConfig("buttons"),
            this.contentType,
            this.contentType.stageId,
        ).then(function (container) {
            self.contentType.addChild(container);
        });
    };

    /**
     * Return content menu options
     *
     * @returns {object}
     */
    Preview.prototype.retrieveOptions = function () {
        var self = this;
        var options = PreviewBase.prototype.retrieveOptions.call(this);

        // options.add = new option({
        //     preview: this,
        //     icon: "<i class='icon-pagebuilder-add'></i>",
        //     title: "Add",
        //     action: self.addLargeCategoryTilesButtons,
        //     classes: ["add-child"],
        //     sort: 10
        // });
        return options;
    };

    /**
     * Set root element
     *
     * @returns {void}
     */
    Preview.prototype.afterRender = function (element) {
        this.element = element;
    };



    /**
     * Check if content type is container
     *
     * @returns {boolean}
     */
    Preview.prototype.isContainer = function () {
        return true;
    };

    return Preview;
});
