define([
    'jquery',
    'underscore',
    'knockout',
    'mage/translate',
    'Magento_PageBuilder/js/events',
    'Magento_PageBuilder/js/content-type/preview-collection',

    'Magento_PageBuilder/js/config',

    'Magento_PageBuilder/js/content-type-factory', 'Magento_PageBuilder/js/content-type-menu/option'
], function (
    $,
    _,
    ko,
    $t,
    events,
    PreviewBase,

    config,

    createContentType, option) {
    'use strict';

    /**
     * @param parent
     * @param config
     * @param stageId
     * @constructor
     */
    function Preview(parent, config, stageId) {
        PreviewBase.call(this, parent, config, stageId);
    }

    Preview.prototype = Object.create(PreviewBase.prototype);




    Preview.prototype.bindEvents = function bindEvents() {
        var self = this;

        PreviewBase.prototype.bindEvents.call(this);

         events.on("Asicspagebuilder_producttiles:dropAfter", function (args) {
            if (args.id === self.contentType.id && self.contentType.children().length === 0) {
                self.addproducttile();
            }
        });



    };





          /**
     * Add producttile
     */
    Preview.prototype.addproducttile = function () {
        var self = this;
        createContentType(
            config.getContentTypeConfig("Asicspagebuilder_producttile"),
            this.contentType,
            this.contentType.stageId,
        ).then(function (container) {
            self.contentType.addChild(container);
        });
    };

    /**
     * Return content menu options
     *
     * @returns {object}
     */
    Preview.prototype.retrieveOptions = function () {
        var self = this;
        var options = PreviewBase.prototype.retrieveOptions.call(this);

        options.add = new option({
            preview: this,
            icon: "<i class='icon-pagebuilder-add'></i>",
            title: "Add",
            action: self.addproducttile,
            classes: ["add-child"],
            sort: 10
        });
        return options;
    };

    /**
     * Set root element
     *
     * @returns {void}
     */
    Preview.prototype.afterRender = function (element) {
        this.element = element;
    };



    /**
     * Check if content type is container
     *
     * @returns {boolean}
     */
    Preview.prototype.isContainer = function () {
        return true;
    };

    return Preview;
});
