<?php

namespace BrittainWynyard\Sales\Cron;

use Magento\Sales\Api\OrderManagementInterface;
use Magento\Sales\Model\ResourceModel\Order\CollectionFactory;

class CancelOrder
{
    protected $orderFailedStatus = [
        'paymentexpress_failed',
        'windcave_failed'
    ];

    /**
     * @var CollectionFactory
     */
    protected $orderCollectionFactory;

    /**
     * @var OrderManagementInterface
     */
    private $orderManagement;

    /**
     * CancelOrder constructor.
     * @param OrderFactory $orderFactory
     */
    public function __construct(
        CollectionFactory $orderCollectionFactory,
        OrderManagementInterface $orderManagement
    ) {
        $this->orderCollectionFactory = $orderCollectionFactory;
        $this->orderManagement = $orderManagement;
    }

    public function execute()
    {
        $collection = $this->orderCollectionFactory->create()
            ->addFieldToSelect('*')
            ->addFieldToFilter('status', ['in' => $this->orderFailedStatus]);

        foreach ($collection as $order) {
            $this->orderManagement->cancel($order->getEntityId());
        }

        return $this;
    }
}
