<?php

namespace BrittainWynyard\Sales\Model\Service;

use BrittainWynyard\Sales\Api\OrderManagementInterface;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Exception\InputException;

/**
 * Class OrderService
 *
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class OrderService implements OrderManagementInterface
{
    /**
     * @var \Magento\Sales\Api\OrderRepositoryInterface
     */
    protected $orderRepository;

    protected $date;

    protected $searchCriteriaBuilder;

    /**
     * Constructor
     *
     * @param \Magento\Sales\Api\OrderRepositoryInterface $orderRepository
     * @param \Magento\Framework\Stdlib\DateTime\DateTime $date
     */
    public function __construct(
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        \Magento\Framework\Stdlib\DateTime\DateTime $date,
        \Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder
    )
    {
        $this->orderRepository = $orderRepository;
        $this->date = $date;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }

    /**
     * Mark a order as fetched
     *
     * @param int $id
     * @return bool
     */
    public function markFetched($id)
    {

        $fetchedDate = $this->date->gmtDate();

        try {
            //load order by entity_id
            $records = $this->orderRepository->getList(
                $this->searchCriteriaBuilder
                    ->addFilter('entity_id', $id)
                    ->create()
            );

            if ($records->getTotalCount() < 1) {
                throw new InputException(__('Could not find order: "%1"', $id));
            }
            $items = $records->getItems();

            $order = array_shift($items);
            // save accredo_fetched_at value
            $order->setAccredoFetchedAt($fetchedDate);
            $this->orderRepository->save($order);
            return true;
        } catch (\Exception $e) {
            throw new CouldNotSaveException(
                __('Could not update order: "%1"', $e->getMessage()),
                $e
            );
        }
    }
}
