<?php
namespace Overdose\Afterpay\Block\Cart;

use Magento\Framework\View\Element\Template;
use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Directory\Model\Currency as Currency;
use Afterpay\Afterpay\Model\Config as AfterpayConfig;

class Button extends Template
{
    /**
     * @var AfterpayConfig
     */
    protected $afterpayConfig;
    /**
     * @var CheckoutSession
     */
    protected $checkoutSession;
    /**
     * @var Currency
     */
    protected $currency;

    /**
     * Button constructor.
     * @param Template\Context $context
     * @param AfterpayConfig $afterpayConfig
     * @param CheckoutSession $checkoutSession
     * @param Currency $currency
     * @param array $data
     */
    public function __construct(
        Template\Context $context,
        AfterpayConfig $afterpayConfig,
        CheckoutSession $checkoutSession,
        Currency $currency,
        array $data
    ) {
        $this->afterpayConfig = $afterpayConfig;
        $this->checkoutSession = $checkoutSession;
        $this->currency = $currency;
        parent::__construct($context, $data);
    }

    /**
     * @return bool
     */
    protected function _getPaymentIsActive()
    {
        return $this->afterpayConfig->getIsPaymentActive();
    }

    /**
     * @return float
     */
    public function getInstallmentsTotal()
    {
        $quote = $this->checkoutSession->getQuote();

        if ($grandTotal = $quote->getGrandTotal()) {
            return $grandTotal / 4;
        }
    }

    /**
     * @return string
     */
    public function getInstallmentsTotalHtml()
    {
        return $this->getCurrency()->getCurrencySymbol() . number_format($this->getInstallmentsTotal(), 2);
    }

    /**
     * @return Currency
     */
    protected function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @return bool
     */
    public function canShow()
    {
        if (!$this->_getPaymentIsActive()) {
            return false;
        }
		else{
				$quote = $this->checkoutSession->getQuote();
				// get grand total (final amount need to be paid)
				$grandTotal =$quote->getGrandTotal();
				$excluded_categories=$this->afterpayConfig->getExcludeCategories();

				if($this->afterpayConfig->getMaxOrderTotal() >= $grandTotal && $this->afterpayConfig->getMinOrderTotal() <= $grandTotal){

					if(!empty($excluded_categories)){
						$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
						$productRepository = $objectManager->get('\Magento\Catalog\Model\ProductRepository');

						foreach ($quote->getAllVisibleItems() as $item) {
							$productid = $item->getProductId();
							$product=$productRepository->getById($productid);
							$categoryids = $product->getCategoryIds();

							foreach($categoryids as $k)
							{
								if(in_array($k,$excluded_categories)){
									return false;
								}
							}
						}
					}
					return true;
				}
				else{
					return false;
				}
		}
    }
}
