<?php

namespace Overdose\Catalog\Plugin;

use Magento\Catalog\Model\ResourceModel\Product\Collection;

class PositionProductSorter
{
    public const SORT_ORDER_ASC = 'ASC';

    public const SORT_ORDER_DESC = 'DESC';

    /**
     * @param Collection $subject
     * @param Collection $result
     * @param string $attribute
     * @param string $dir
     * @return Collection
     */
    public function afterAddAttributeToSort(
        Collection $subject,
        Collection $result,
                   $attribute,
                   $dir = self::SORT_ORDER_ASC
    ) {
        if ($attribute === 'position') {
            // additional sorting rule
            $subject->setOrder('product_id', self::SORT_ORDER_DESC);
        }
        return $result;
    }
}
