<?php

namespace Overdose\Catalog\Setup\Patch\Data;

use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Overdose\Catalog\Model\RebuildPositionCategory;

/**
 * Patch is mechanism, that allows to do atomic upgrade data changes.
 */
class RebuildPositionMissingPatch implements DataPatchInterface
{
    /**
     * @var ModuleDataSetupInterface
     */
    private ModuleDataSetupInterface $moduleDataSetup;
    /**
     * @var RebuildPositionCategory
     */
    protected $rebuildPositionCategory;

    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     */
    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        RebuildPositionCategory  $rebuildPositionCategory
    ) {
        $this->rebuildPositionCategory = $rebuildPositionCategory;
        $this->moduleDataSetup = $moduleDataSetup;
    }

    /**
     * Do Upgrade.
     *
     * @return void
     */
    public function apply()
    {
        $this->moduleDataSetup->getConnection()->startSetup();

        $connection = $this->moduleDataSetup->getConnection();
        $categoryProductTable = $this->moduleDataSetup->getTable('catalog_category_product');

        $select = $connection->select();
        $select->from(['ccp' => $categoryProductTable], ['category_id', 'COUNT(*) as product_count'])
               ->where('position = ?', 0)
               ->group('ccp.category_id')
               ->having('COUNT(*) >= ?', 2);

        $result = $connection->fetchAll($select);

        foreach ($result as $row) {
            $categoryId = $row['category_id'];
            $this->rebuildPositionCategory->rebuildPositionByCategoryId($categoryId);
        }

        $this->moduleDataSetup->getConnection()->endSetup();
    }

    /**
     * Get aliases (previous names) for the patch.
     *
     * @return string[]
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * Get array of patches that have to be executed prior to this.
     *
     * Example of implementation:
     *
     * [
     *      \Vendor_Name\Module_Name\Setup\Patch\Patch1::class,
     *      \Vendor_Name\Module_Name\Setup\Patch\Patch2::class
     * ]
     *
     * @return string[]
     */
    public static function getDependencies()
    {
        return [];
    }
}
