<?php

declare(strict_types=1);

namespace Overdose\CatalogAttribute\Plugin\Model\Category\Attribute\Backend;

use Magento\Catalog\Model\Category;
use Magento\Catalog\Model\Category\Attribute\Backend\Image;

class ImagePlugin
{
    /**
     * Fix saving mobile_category_image category image when uploading from the gallery.
     *
     * @param Image $backendImage
     * @param Image $result
     * @param Category $category
     * @return Image
     */
    public function afterBeforeSave(Image $backendImage, Image $result, $category): Image
    {
        $attributeName = $backendImage->getAttribute()->getName();
        $mobileImage = $category->getData('mobile_category_image');

        if ($attributeName !== 'mobile_category_image' || !$mobileImage) {
            return $backendImage;
        }

        if (is_string($mobileImage)) {
            $category->setData('mobile_category_image', basename($mobileImage));
        }
        return $result;
    }
}
