<?php

namespace Overdose\DataLayer\Plugin;

use Magento\Checkout\Model\Session;
use Magento\Framework\App\Response\RedirectInterface;
use Overdose\DataLayer\Helper\Cookies;

/**
 * Class GenericPlugin
 * @package Overdose\DataLayer\Plugin
 */
class GenericPlugin {

    const SUCCESSPAGE_KEY = 'success';
    const EMAIL_CHECK_URL_KEY = 'checkout';

    /**#@+
     * Constructor params
     */
    protected RedirectInterface $redirect;
    protected Session $session;
    protected Cookies $cookiesHelper;
    /**#@-*/

    /**
     * GenericPlugin constructor.
     * @param Cookies $cookiesHelper
     * @param RedirectInterface $redirect
     * @param Session $session
     */
    public function __construct(
        Cookies $cookiesHelper,
        RedirectInterface $redirect,
        Session $session
    ) {
        $this->cookiesHelper = $cookiesHelper;
        $this->redirect = $redirect;
        $this->session = $session;
    }
}
