<?php

namespace Overdose\SnowdogMenu\Plugin\Controller\Adminhtml\Menu;

use Magento\Framework\App\Filesystem\DirectoryList;
use Overdose\SnowdogMenu\Helper\Data as Helper;
use Overdose\SnowdogMenu\Block\Menu;
use Magento\Framework\Filesystem;
use Magento\Framework\View\LayoutFactory;
use Snowdog\Menu\Api\MenuRepositoryInterface;
use Magento\Framework\App\Cache\Manager;

/**
 * Class Save
 */
class Save
{
    /**
     * @var Helper
     */
    protected $helper;

    /**
     * @var Filesystem
     */
    protected $fileSystem;

    /**
     * @var LayoutFactory
     */
    protected $layoutFactory;

    /**
     * @var MenuRepositoryInterface
     */
    private $menuRepository;

    /**
     * @var Manager
     */
    protected $cacheManager;

    /**
     * Save constructor.
     * @param Helper $helper
     * @param Filesystem $fileSystem
     * @param MenuRepositoryInterface $menuRepository
     * @param LayoutFactory $layoutFactory
     * @param Manager $cacheManager
     */
    public function __construct
    (
        Helper $helper,
        Filesystem $fileSystem,
        MenuRepositoryInterface $menuRepository,
        LayoutFactory $layoutFactory,
        Manager $cacheManager
    ) {
        $this->helper = $helper;
        $this->fileSystem = $fileSystem;
        $this->menuRepository = $menuRepository;
        $this->layoutFactory = $layoutFactory;
        $this->cacheManager = $cacheManager;
    }

    public function afterExecute($subject, $result)
    {
        try {
            $menuId = $subject->getRequest()->getParam('menu_id');
            $menu = $this->menuRepository->getById($menuId);
            if ($menu && $menu->getId() && $menu->getIdentifier() === $this->helper->getMobileMenuIdentifier()) {
                $layout = $this->layoutFactory->create();
                $block = $layout->createBlock(
                    Menu::class,
                    'menu-main-mobile'
                )->setData('area', 'frontend');
                $block->setData('render_in_admin', true);
                $block->setData('menu', $menu->getIdentifier());
                $dirReader = $this->fileSystem->getDirectoryWrite(DirectoryList::MEDIA);
                $dirReader->delete($this->helper->getPathWriteMenuInPub() . '/mobile_menu.html');
                if ($this->helper->getClearCacheMenu()) {
                    $types = array('layout', 'block_html', 'full_page');
                    $this->cacheManager->clean($types);
                } else {
                    $block->getAjaxMenuHtml();
                }
            }

        } catch (\Exception $e) {

        }

        return $result;
    }
}
