<?php

namespace Verifone\Hosted\Observer;

use VerifoneEcomAPI\ApiWrapper\Authentication\BasicAuth;
use VerifoneEcomAPI\ApiWrapper\Http\ApiClient\Client;

class SalesOrderInvoicePay implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * @var \Verifone\Hosted\Helper\Verifone
     */
    protected $_checkoutHelper;
    public function __construct(
        \Verifone\Hosted\Helper\Verifone $checkoutHelper
    ) {
        $this->_checkoutHelper = $checkoutHelper;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $invoice = $observer->getEvent()->getInvoice();
        $order = $invoice->getOrder();
        $payment = $order->getPayment();
        if ($payment->getMethod() != "verifone_hosted") {
            return;
        }

        $additional_data = $order->getPayment()->getData();
        if (!isset($additional_data['additional_information']['manual_capture'])) {
            return;
        }
        if ($additional_data['additional_information']['manual_capture'] != 'yes') {
            return;
        }
        if (!isset($additional_data['additional_information']['verifone_order_number'])) {
            return;
        }
        $transactionId = $additional_data['additional_information']['verifone_order_number'];
        $paymentMethod = $payment->getMethodInstance();
        $this->_checkoutHelper->voidOrCapture($order, $payment, $transactionId, $paymentMethod, 'capture');
    }
}
