define([
    'jquery',
    'slick',
    'domReady!'
], function ($) {
    return function (config, element) {
        setTimeout(function () {
            const $slider = $(element);
            const getItemWidth = () => {
                return window.innerWidth <= 1024 ? 130 : 210;
            };

            const initialize = () => {
                if ($slider.hasClass('slick-initialized')) {
                    $slider.slick('unslick');
                }

                const itemWidth = getItemWidth();
                const containerWidth = $slider.width();
                const slideCount = $slider.children().length;
                const totalSlidesWidth = slideCount * itemWidth;
                const showArrows = totalSlidesWidth > containerWidth;
                const slidesToShow = Math.floor(containerWidth / itemWidth);

                $slider.slick({
                    dots: false,
                    infinite: false,
                    speed: 300,
                    variableWidth: true,
                    arrows: showArrows,
                    slidesToShow: slidesToShow
                });
            };

            initialize();
        });
    }
});
