define([
    'jquery',
], function ($) {
    return function (config, element) {
        var productItemsContainer = element;
        var productItems = productItemsContainer.children;
        var numOfChildren = productItems.length;
        var screenIsAboveTablet = true;

        function generateNumOfColumnPerRow() {
            var numOfColumnPerRow = 1;

            //responsive
            if (window.innerWidth <= 1024) {
                numOfColumnPerRow = 2;
                screenIsAboveTablet = false;
            }
            else {
                numOfColumnPerRow = 3;
                screenIsAboveTablet = true;
            }

            return numOfColumnPerRow;
        }

        function insertRemoveBorderBottomClass(productItemsContainer, numOfChildren) {
            var numOfColumnPerRow = generateNumOfColumnPerRow();
            var remainingChildren = numOfChildren % numOfColumnPerRow;
            var numColumnToRemoveBottomBorder = remainingChildren;

            if (remainingChildren == 0) {
                numColumnToRemoveBottomBorder = numOfColumnPerRow;
            }

            for (var i = numColumnToRemoveBottomBorder; i >= 1; i--) {
                productItems[numOfChildren - i].classList.add('product-item--remove-bottom-border')
            }
        }

        function removeRemoveBorderBottomClass() {
            var allProductItemWithRemoveBorderBottom = document.querySelectorAll('.product-item--remove-bottom-border');
            for (var i = 0; i < allProductItemWithRemoveBorderBottom.length; i++) {
                allProductItemWithRemoveBorderBottom[i].classList.remove('product-item--remove-bottom-border');
            }
        }

        removeRemoveBorderBottomClass();
        insertRemoveBorderBottomClass(productItemsContainer, numOfChildren);

        window.addEventListener('resize', function () {
            var removeBottomBorderResizeTrigger = false;
            if((window.innerWidth > 1025 && !screenIsAboveTablet) || (window.innerWidth <= 1025 && screenIsAboveTablet)){
                removeBottomBorderResizeTrigger = true;
            }

            if (removeBottomBorderResizeTrigger) {
                removeRemoveBorderBottomClass();
                insertRemoveBorderBottomClass(productItemsContainer, numOfChildren);
            }
        })
    }
});
