define([
    'jquery',
    'Magento_Checkout/js/model/quote'
], function ($, quote) {
    'use strict';
    return function (Component) {
        return Component.extend({
            initialize: function () {
                var self = this;
                return this._super();
            },
            /**
             * @return {*}
             */
            getIncludingValue: function () {
                if (!quote.shippingMethod()) {
                    return 'Calculated at Checkout';
                }
                
                var price;

                if (!this.isCalculated()) {
                    return this.notCalculatedMessage;
                }
                price = this.totals()['shipping_incl_tax'];


                if (price == 0) {
                    return 'FREE';
                }
                else {
                    return this.getFormattedPrice(price);
                }
            },

            /**
             * @return {*}
             */
            getExcludingValue: function () {
                if (!quote.shippingMethod()) {
                    return 'Calculated at Checkout';
                }
                var price;

                if (!this.isCalculated()) {
                    return this.notCalculatedMessage;
                }
                price = this.totals()['shipping_amount'];

                if (price == 0) {
                    return 'FREE';
                }
                else {
                    return this.getFormattedPrice(price);
                }
                // return this.getFormattedPrice(price);
            }
        });
    }
});
