define(['jquery',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/model/url-builder',
    'mage/storage',
    'Magento_Checkout/js/model/error-processor',
    'Magento_Customer/js/model/customer',
    'Magento_Checkout/js/model/full-screen-loader',
    'Magento_Customer/js/customer-data',
    'Magento_Ui/js/modal/modal',
    'mage/url'
], function (
    $,
    quote,
    urlBuilder,
    storage,
    errorProcessor,
    customer,
    fullScreenLoader,
    customerData,
    modal,
    mageUrl
) {
    'use strict';
    //The original file - vendor/px/payments/view/frontend/web/js/action/start-pxpay2-iframe.js
    //Removed variables: constructIframe, hideOverlay, showOverlay, unlockInput, lockInput, lockedElements, overlay

    var constructIframe = function (containerId, url, module, iframeWidth, iframeHeight) {

        //Removed all code related to overlay

        var containerIdEx = "#" + containerId;
        $(containerIdEx).empty();

        try {
            var iframe = $('<iframe>', {
                src: url,
                class: 'windcave_pxpay2_iframe',
                id: containerId + '_iframe',
                frameborder: 0,
                scrolling: 'yes',
                width: iframeWidth + 'px',
                height: iframeHeight + 'px'
            });
            iframe.css("z-index", "9999");
            iframe.css("position", "relative");
            iframe.appendTo(containerIdEx);
            iframe.on("load", function () {
                var content = iframe[0].contentWindow;

                if (content.location.pathname === '/asics_view/pxpay2/pxpay2iframe/redirectback/') {
                    fullScreenLoader.startLoader();
                    $(containerPopup).modal('closeModal');
                }

                if (content) {
                    try {
                        if (content.location && content.location.host) {
                            $(containerIdEx).css("display", "none");
                            fullScreenLoader.startLoader();

                            var query = content.location.search;
                            var returnUrl = mageUrl.build(module + '/pxpay2iframe/redirect/' + query);

                            // Adding a 0ms delay to let browser redraw the page and make full-screen loader appear
                            setTimeout(function () {
                                $.mage.redirect(returnUrl);
                            }, 0);
                        }
                    } catch (e) {
                    }
                } else {
                    $(containerIdEx).css("display", "block");
                }
            });

            //custom code
            const popupBackBtn = '.windcave_pxpay_iframe_container-popup_checkout-back-btn';
            const containerPopup = '#windcave_pxpay_iframe_container-popup';

            const options = {
                type: 'popup',
                responsive: true,
                innerScroll: true,
                modalClass: 'windcave-pxpay-iframe-modal',
                overlayClass: 'windcave-pxpay-iframe-overlay',
                closed: function () {
                    fullScreenLoader.startLoader();
                    window.location.reload();
                },
                title: '',
                buttons: []
            };

            $(containerPopup).modal(options).modal('openModal');

            $(popupBackBtn).on('click', function () {
                $(containerPopup).modal('closeModal');
            });

            //end of custom code
        } catch (e) {
            console.log("Constructing iFrame failed.");
        }
    };

    return function (messageContainer, module, iframeWidth, iframeHeight) {
        customerData.invalidate(['cart']);

        //custom code
        const totalPrice = customerData.get('cart')().subtotal_incl_tax;

        const popapTotalPrice = $('.windcave_pxpay_iframe_container-popup__total-price');
        popapTotalPrice.html(totalPrice);
        //end of custom code

        var serviceUrl;
        if (!customer.isLoggedIn()) {
            serviceUrl = urlBuilder.createUrl('/guest-carts/:module/redirect-to-pxpay2', {module: module});
        } else {
            serviceUrl = urlBuilder.createUrl('/carts/mine/:module/redirect-to-pxpay2', {module: module});
        }

        fullScreenLoader.startLoader();

        return storage.get(serviceUrl)
            .done(function (redirectUrl) {
                fullScreenLoader.stopLoader();
                constructIframe('windcave_pxpay_iframe_container', redirectUrl, module, iframeWidth, iframeHeight);
            })
            .fail(function (response) {
                fullScreenLoader.stopLoader();
                try {
                    errorProcessor.process(response, messageContainer);
                } catch (e) {
                    var errorResponse = {status: 500, responseText: JSON.stringify({message: "Internal server error"})};
                    errorProcessor.process(errorResponse, messageContainer);

                    var options = {
                        type: 'popup',
                        responsive: true,
                        innerScroll: true,
                        title: 'Internal server error.',
                        buttons: [{
                            text: $.mage.__('Continue'),
                            class: '',
                            click: function () {
                                this.closeModal();
                                window.location.reload(); //custom code
                            }
                        }]
                    };
                    $('<div></div>').html('Please contact support.').modal(options).modal('openModal');
                }
            });
    };
});
