<?php
namespace PaymentExpress\PxPay2\Controller\PxFusion;

class WaitingQuote extends \Magento\Framework\App\Action\Action
{

    /**
     *
     * @var \PaymentExpress\PxPay2\Logger\DpsLogger
     */
    private $_logger;

    /**
     *
     * @var \Magento\Sales\Model\Order
     */
    private $_orderManager;

    /**
     *
     * @var \Magento\Checkout\Model\Session
     */
    private $_checkoutSession;

    /**
     *
     * @var \PaymentExpress\PxPay2\Helper\PxFusion\Configuration
     */
    private $_configuration;

    public function __construct(\Magento\Framework\App\Action\Context $context)
    {
        parent::__construct($context);
        $this->_checkoutSession = $this->_objectManager->get(\Magento\Checkout\Model\Session::class);
        $this->_orderManager = $this->_objectManager->get(\Magento\Sales\Model\Order::class);
        $this->_configuration = $this->_objectManager->get("\PaymentExpress\PxPay2\Helper\PxFusion\Configuration");
        $this->_logger = $this->_objectManager->get("\PaymentExpress\PxPay2\Logger\DpsLogger");
        $this->_logger->info(__METHOD__);
    }

    private function firstOrSecond($a, $b) {
        if (isset($a) && !is_null($a))
            return $a;
        return $b;
    }

    public function execute()
    {
        $reservedOrderId = $this->firstOrSecond($this->getRequest()->getParam('reservedOrderId'), $this->getRequest()->getParam('reservedorderid'));
        $triedTimes = $this->firstOrSecond($this->getRequest()->getParam("triedTimes"), $this->getRequest()->getParam("triedtimes"));

        $lastRealOrderId = $this->_checkoutSession->getLastRealOrderId();
        $this->_logger->info(
            __METHOD__ .
            " reservedOrderId:{$reservedOrderId} triedTimes:{$triedTimes} lastRealOrderId:{$lastRealOrderId}"
        );

        $order = $this->_orderManager->loadByAttribute("increment_id", $reservedOrderId);
        if ($order->getId()) {
            $quoteId = $order->getQuoteId();
            $this->_checkoutSession->setLastQuoteId($quoteId);
            $this->_checkoutSession->setLastSuccessQuoteId($quoteId);
            $this->_checkoutSession->setLastOrderId($order->getId());
            $this->_checkoutSession->setLastRealOrderId($order->getIncrementId());
            $this->_checkoutSession->setLastOrderStatus($order->getStatus());
            
            $this->_logger->info(
                __METHOD__ .
                " load order:{$reservedOrderId} from db and redirect to the success page."
            );
            $this->_redirect("checkout/onepage/success", [
                "_secure" => true
                ]);
            return;
        }
        
        if ($triedTimes > 10) {
            // defensive code. should never happens.
            $this->_logger->info(
                __METHOD__ .
                " order:{$reservedOrderId} is not created yet, redirecting to the cart page," .
                " please check if there is any excption happened."
            );

            $redirectDetails = $this->_configuration->getRedirectOnErrorDetails();
            $this->_redirect($redirectDetails['url'], $redirectDetails['params']);
            return;
        }
        
        sleep(1); // wait for order ready.
        
        $this->_redirect("pxpay2/pxfusion/waitingQuote", [
            "_secure" => true,
            "triedtimes" => $triedTimes + 1,
            "reservedorderid" => $reservedOrderId
            ]);
    }
}
