<?php

/**
 * Copyright © Windcave, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace PaymentExpress\PxPay2\Setup\Patch\Data;

use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchRevertableInterface;

class NewOrderStatusesPatch implements DataPatchInterface, PatchRevertableInterface
{
    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     */
    public function __construct(ModuleDataSetupInterface $moduleDataSetup)
    {
        /**
         * If before, we pass $setup as argument in install/upgrade function, from now we start
         * inject it with DI. If you want to use setup, you can inject it, with the same way as here
         */
        $this->moduleDataSetup = $moduleDataSetup;
    }

    /**
     * @inheritdoc
     */
    public function apply()
    {
        $connection = $this->moduleDataSetup->getConnection();
        $connection->startSetup();

        $data[] = ['status' => 'paymentexpress_authorized', 'label' => 'Payment Authorized'];
        $data[] = ['status' => 'paymentexpress_failed', 'label' => 'Payment Failed'];
        try {
            $connection->insertArray(
                $this->moduleDataSetup->getTable('sales_order_status'),
                ['status', 'label'],
                $data
            );
        } catch (\Exception $ex) {
            // Unable to add entries to the table. Possibly the data is already there?
        }

        try {
            $connection->insertArray(
                $this->moduleDataSetup->getTable('sales_order_status_state'),
                ['status', 'state', 'is_default','visible_on_front'],
                [
                    ['paymentexpress_authorized','pending_payment', '0', '1'],
                    ['paymentexpress_failed','pending_payment', '0', '1'],
                ]
            );
        } catch (\Exception $ex) {
            // Unable to add entries to the table. Possibly the data is already there?
        }
        $connection->endSetup();
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function revert()
    {
        $this->moduleDataSetup->getConnection()->startSetup();
        //Here should go code that will revert all operations from `apply` method
        //Please note, that some operations, like removing data from column, that is in role of foreign key reference
        //is dangerous, because it can trigger ON DELETE statement
        $this->moduleDataSetup->getConnection()->endSetup();
    }

    /**
     * @inheritdoc
     */
    public function getAliases()
    {
        /**
         * This internal method, that means that some patches with time can change their names,
         * but changing name should not affect installation process, that's why if we will change name of the patch
         * we will add alias here
         */
        return [];
    }

    /**
     * @inheritdoc
     */
    public static function getVersion()
    {
        return '0.8.0';
    }
}
